<?php

namespace app\home\controller;

use app\common\controller\Frontend;
use hehe\Verify;
use think\Db;


class Index extends Frontend {

    protected $layout = 'default';

    protected $noNeedRight = ['*'];
    protected $noNeedLogin = ['*'];

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub

        if(!$this->request->isPjax()){
//            $this->pjaxLayout();
            $this->view->engine->layout('default/layout/layout_' . $this->layout);
        }

    }

    public function index() {
        $category_id = $this->request->has('category_id') ? $this->request->param('category_id') : false;
        $category = Db::name('goods_category')->order('weigh desc, id desc')->select();
        if($category_id){
            foreach($category as $key => $val){
                if($category_id == $val['id']){
                    $category[$key]['active'] = true;
                    break;
                }
            }
        }else{
            foreach($category as $key => $val){
                if($val['pid'] == 0){
                    $category_id = $val['id'];
                    $category[$key]['active'] = true;
                    break;
                }
            }
        }

        $goods_category = db::name('goods_category')->field('id, name')->where(['id' => $category_id])->whereOr(['pid' => $category_id])->order('weigh desc, id desc')->select();
        $category_ids = array_column($goods_category, 'id');
        $category_ids = implode(',', $category_ids);
        $goods = db::name('goods')
            ->field('id, category_id, cover, name, is_sku, sku, price')
            ->where("`category_id` in ({$category_ids})")
            ->where(['shelf' => 1])
            ->order('weigh desc')
            ->select();
		$agency = $this->userAgency();
        foreach($goods_category as $key => $val){
            $goods_category[$key]['goods'] = [];
            foreach($goods as $v){
                if($val['id'] == $v['category_id']){
                    $goods_category[$key]['goods'][] = $this->indexClGd($v, $agency);
                }
            }
        }


//        echo '<pre>'; print_r($goods_category);die;


        $this->assign([
            'category' => $category,
            'goods_category' => $goods_category
        ]);
        return view('default/index');
    }



	/**
	 * 处理商品列表信息
	 */
    public function indexClGd($goods, $agency){
        if($goods['is_sku'] == 0){
            $price = json_decode($goods['price'], true);
            $goods['crossed_price'] = sprintf('%.2f', $price['crossed_price']);
			if(empty($this->user['agency_id'])){
				$goods['init_price'] = sprintf('%.2f', $price['sale_price']);
			}else{
				if(Verify::isEmpty($price['agency_price_' . $this->user['agency_id']])){
					$goods['init_price'] = sprintf('%.2f', $price['sale_price'] * ($agency[$this->user['agency_id']] / 10));
				}else{
					$goods['init_price'] = $price['agency_price_' . $this->user['agency_id']];
				}
			}

        }
        if($goods['is_sku'] == 1){
            $sku = json_decode($goods['sku'], true);
			if(empty($this->user['agency_id'])){
				$goods['init_price'] = sprintf('%.2f', $sku[0]['sale_price']);
			}else{
				if(Verify::isEmpty($sku[0]['agency_price_' . $this->user['agency_id']])){
					if(isset($agency[$this->user['agency_id']])){
						$goods['init_price'] = sprintf('%.2f', $sku[0]['sale_price'] * ($agency[$this->user['agency_id']] / 10));
					}else{
						$goods['init_price'] = $sku[0]['sale_price'];
					}
				}else{
					$goods['init_price'] = $sku[0]['agency_price_' . $this->user['agency_id']];
				}
			}
            $goods['crossed_price'] = sprintf('%.2f', $sku[0]['crossed_price']);
        }
        return $goods;
    }




    public function goods(){
        $id = $this->request->param('id');
		$goods = db::name('goods')->where(['id' => $id])->find();
        $category = db::name('goods_category')->where(['id' => $goods['category_id']])->find();
		$agency = $this->userAgency();
		$goods = $this->goodsDetail($goods, $agency);

//		echo '<pre>'; print_r($goods);die;
        $this->assign([
            'category' => $category,
            'goods' => $goods,
        ]);
        return view('default/goods');
    }






}
